<?php
/**
 * Form configuration
 *
 * PHP version 8
 *
 * Copyright (C) Ere Maijala 2018-2021
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @category MLInvoice
 * @package  MLInvoice\Base
 * @author   Ere Maijala <ere@labs.fi>
 * @license  http://opensource.org/licenses/gpl-2.0.php GNU General Public License
 * @link     http://labs.fi/mlinvoice.eng.php
 */

/**
 * Get form configuration
 *
 * @param string $form     Form name
 * @param string $func     Current function
 * @param ?int   $id       Record ID (if any)
 * @param ?int   $parentId Parent record ID (if any)
 *
 * @return array
 */
function getFormConfig($form, $func, ?int $id = null, ?int $parentId = null)
{
    $strForm = $form;
    $strFunc = $func;
    include 'form_switch.php';

    $fields = [];
    foreach ($astrFormElements as $field) {
        $fields[$field['name']] = $field;
    }
    return [
        'type' => $strForm,
        'title' => $locTitle ?? '',
        'readOnly' => $readOnlyForm,
        'accessLevels' => $levelsAllowed,
        'table' => $strTable,
        'parentKey' => $strParentKey ?? null,
        'tableAlias' => $strListTableAlias,
        'copyLink' => $copyLinkOverride,
        'extraButtons' => $extraButtons,
        'fields' => $fields,
        'dataAttrs' => $formDataAttrs,
        'searchFields' => $astrSearchFields ?? null,
        'addressAutocomplete' => $addressAutocomplete,
        'clearAfterRowAdded' => $clearRowValuesAfterAdd,
        'onAfterRowAdded' => $onAfterRowAdded,
        'popupHTML' => $popupHTML ?? '',
        'buttonGroups' => $buttonGroups ?? [],
        'inputFieldTypes' => $inputFieldTypes,
        'searchFieldTypes' => $searchFieldTypes,
    ];
}
